<?php

/** @var \Laravel\Lumen\Routing\Router $router */

/*
|--------------------------------------------------------------------------
| Application Routes
|--------------------------------------------------------------------------
|
| Here is where you can register all of the routes for an application.
| It is a breeze. Simply tell Lumen the URIs it should respond to
| and give it the Closure to call when that URI is requested.
|
*/

$router->get('/', function () use ($router) {
    return $router->app->version();
});

$router->get('/users', 'ParkingController@users');
$router->post('/login', 'ParkingController@doLogin');
$router->post('/request_parkingrate', 'ParkingController@requestParkingRate');
$router->post('/request_parkingrate_manual', 'ParkingController@requestParkingRateManual');
$router->post('/save_transaction', 'ParkingController@saveTransaction');
$router->post('/upload_img', 'ParkingController@upload_img');
$router->post('/save_data_in', 'ParkingController@pos_in');
$router->post('/vehicle_list', 'ParkingController@master_vehicle');
$router->post('/lobby_list', 'ParkingController@master_lobby');
$router->post('/logout', 'ParkingController@doLogout');
