<?php

namespace App\Http\Controllers;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\DB;

class ParkingController extends Controller
{
	
    public function users()
    {
    
		$data = DB::table("parking_in")->selectRaw("now() AS waktu_keluar")->first();
				dd(($data->waktu_keluar));
    }
	
	public function info($id){
		return $id;
	}
	
	public function img_list($id){
		//425461671666PM945
		$site = substr($id,0,3);
		$data = DB::table("parking_in")
		->where("site_id",$site)
		->where("ti_qrcode",substr($id,3,17))
		->select("ti_img")
		->first();
		
		
		return $data->ti_img;
		/*
		$img = explode("|",$data->ti_img);
		$c = count($img);
		for($i=0;$i<$c;$i++){
			//echo "<img src='".assets('storage/parking_image')."/".$img[$i]."' alt='' title='' />";
		}
		*/
	}
	function getAuthorizationHeader(){
        $headers = null;
        if (isset($_SERVER['Authorization'])) {
            $headers = trim($_SERVER["Authorization"]);
        }
        else if (isset($_SERVER['HTTP_AUTHORIZATION'])) { //Nginx or fast CGI
            $headers = trim($_SERVER["HTTP_AUTHORIZATION"]);
        } elseif (function_exists('apache_request_headers')) {
            $requestHeaders = apache_request_headers();
            // Server-side fix for bug in old Android versions (a nice side-effect of this fix means we don't care about capitalization for Authorization)
            $requestHeaders = array_combine(array_map('ucwords', array_keys($requestHeaders)), array_values($requestHeaders));
            //print_r($requestHeaders);
            if (isset($requestHeaders['Authorization'])) {
                $headers = trim($requestHeaders['Authorization']);
            }
        }
        return $headers;
    }
	
	function getBearerToken_old() {
		$headers = $this->getAuthorizationHeader();
		// HEADER: Get the access token from the header
		if (!empty($headers)) {
			if (preg_match('/Bearer\s(\S+)/', $headers, $matches)) {
				return $matches[1];
			}
		}
		return null;
	}
	
	function getBearerToken() {
		$token = "1234567890123";
		$rs = "";
		$headers = $this->getAuthorizationHeader();
		// HEADER: Get the access token from the header
		if (!empty($headers)) {
			if (preg_match('/Bearer\s(\S+)/', $headers, $matches)) {
				$rs =  $matches[1];
			}
		}
		if($rs == $token){
			return true;
		}
		return null;
	}
	
	function doLogin(Request $request){
		if($this->getBearerToken()  ==  false){
			return response()->json([
				'success' => false,
				'message' =>'Invalid credential',
				'data'    => null
				], 200);
		}
		else
		{
			$validator = Validator::make($request->all(), [
				'site_id'   => 'required',
				'user_id' => 'required',
				'device_id' => 'required',
				'lobby_id' => 'required',
				'passwd' => 'required',
			]);

			if ($validator->fails()) {

				return response()->json([
					'success' => false,
					'message' => 'Invalid login parameter!',
					'data'   => $validator->errors()
				],200);

			} else {

				$data = DB::table("master_user")
				->where("site_id",$request->site_id)
				->where("userid",$request->user_id)
				->where("pwd",md5($request->passwd))
				->select("fullname","ustatus","device_id")
				->selectRAW("LPAD(FLOOR(RAND() * 999999.99), 6, '0') as shift_id")
				->get()->first();
				
				if($data == null){
					return response()->json([
						'success' => false,
						'message' =>'Invalid login',
						'data'    => null
						], 200);
				}
				else{
					$d_device_id = $data->device_id;
					$d_login_status = $data->ustatus;
					
					if($d_login_status == 'S' and $d_device_id != $request->device_id){
						return response()->json([
						'success' => false,
						'message' =>'User is active on another device!',
						'data'    => ''
						], 200);
					}
					else{
						
						$now = date('Y-m-d H:i:s');
						
						if($d_login_status == "E"){
							DB::table("master_user")
							->where("site_id",$request->site_id)
							->where("userid",$request->user_id)
							->update([
							"ustatus"=>"S",
							"device_id"=>$request->device_id,
							"lobby_id"=>$request->lobby_id,
							"startshift"=>$now,
							"shift_id"=>$data->shift_id
							]);
						}
						
						
						return response()->json([
						'success' => true,
						'message' =>'Login success',
						'data'    => $data
						], 200);
					}
					
				}
			}
		}
	}
	
	function cekDevice(Request $request){
		if($this->getBearerToken()  ==  false){
			return response()->json([
				'success' => false,
				'message' =>'Invalid credential',
				'data'    => null
				], 200);
		}
		else
		{
			$validator = Validator::make($request->all(), [
				'site_id'   => 'required',
				'device_id' => 'required',
			]);

			if ($validator->fails()) {

				return response()->json([
					'success' => false,
					'message' => 'Invalid request parameter!',
					'data'   => $validator->errors()
				],200);

			} else {
				
				DB::table("master_device")
				->insert(["site_id"=>$request->site_id,"device_id"=>$request->device_id]);
				
			
				//select a.siteid, a.sitename, b.device_id from master_site a 
				//left join master_device b on a.siteid = b.site_id 
				$data = DB::table("master_device")
				->leftJoin("master_device","master_site.siteid","=","master_device.site_id")
				->where("site_id",$request->site_id)
				->where("device_id",$request->device_id)
				->select("master_site.siteid as site_id","master_site.sitename as site_name","master_device.device_id")
				->get()->first();
				
				if($data == null){
					return response()->json([
						'success' => false,
						'message' =>'Device not registered',
						'data'    => null
						], 200);
				}
				else{
					return response()->json([
						'success' => true,
						'message' =>'Device cek success',
						'data'    => $data
						], 200);
				}
			}
		}
	}
	
	function doLogout(Request $request){
		if($this->getBearerToken()  ==  false){
			return response()->json([
				'success' => false,
				'message' =>'Invalid credential',
				'data'    => null
				], 200);
		}
		else
		{
			$validator = Validator::make($request->all(), [
				'site_id'   => 'required',
				'user_id' => 'required',
				'device_id' => 'required'
			]);

			if ($validator->fails()) {

				return response()->json([
					'success' => false,
					'message' => 'Invalid logout parameter!',
					'data'   => $validator->errors()
				],200);

			} else {
					
					//settlement
					if($request->site_id == "LOP"){
						$now = date('Y-m-d H:i:s', strtotime('now +1 hour'));
					}
					else{
						$now = date('Y-m-d H:i:s');
					}
					
					$data = DB::table("users")
					->where("site_id",$request->site_id)
					->where("userid",$request->user_id)
					->where("device_id",$request->device_id)->first();
					
					
					DB::table("users")
					->where("site_id",$request->site_id)
					->where("siteid",$request->user_id)
					->where("device_id",$request->device_id)
					->update(["ustatus"=>"E","endshift"=>$now]);
					
					$sql = 
					"select users.userid,  users.shift_id,  users.fullname fullname, device_id gateout, COUNT(*) AS qty, SUM(parking_fee) AS casual, 
					SUM(CASE WHEN lt_fee > 0 THEN 1 ELSE 0 END) AS qty_lt,
					SUM(CASE WHEN payment_type > 0 THEN 1 ELSE 0 END) AS prepaid_qty,
					SUM(CASE WHEN payment_type > 0 THEN parking_fee ELSE 0 END) AS prepaid_amount,
					SUM(CASE WHEN lt_fee > 0 THEN lt_fee ELSE 0 END) AS amount_lt,
					SUM(CASE WHEN userin = 'MANUAL' THEN 1 ELSE 0 END) AS qty_manual,
					SUM(CASE WHEN userin = 'MANUAL' THEN parking_fee ELSE 0 END) AS amount_manual, 
					DATE_FORMAT(users.startshift,'%Y-%m-%d %H:%i:%s') startshift, 
					DATE_FORMAT(users.endshift,'%Y-%m-%d %H:%i:%s') endshift
					FROM parking_out_mobile right join users on parking_out_mobile.userout = users.userid 
					where parking_out_mobile.shift_id = '".$data->shift_id."'
					AND users.ustatus = 'E'  and users.userid='".$data->userid."' group by users.userid,
					users.fullname, parking_out_mobile.device_id, users.startshift, users.endshift, users.shift_id";
					
						$data = DB::select(DB::RAW($sql));
						
						//dd($data);
						foreach($data as $rs){
							$gate = $rs->gateout;
							$username = $rs->fullname;
							$userid = $rs->userid;
							$start_shift = $rs->startshift;
							$end_shift = $rs->endshift;
							$casual_amount = $rs->casual;
							$casual_qty =$rs->qty;
							$lt_amount = $rs->amount_lt;
							$lt_qty = $rs->qty_lt;  //$rs->qty_lt;
							$manual_amount = $rs->amount_manual;  //$rs->amount_manual;
							$manual_qty = $rs->qty_manual;  //$rs->qty_manual;
							$prepaid_qty = $rs->prepaid_qty;  //$rs->prepaid_qty;
							$prepaid_amount = $rs->prepaid_amount;
							$shift_id = $rs->shift_id;
		//insert into settlement (userid, gate, start_shift, end_shift, casual_amount, casual_qty,"
		//        + "lt_amount, lt_qty, manual_amount, manual_qty, shift_id, prepaid_qty,prepaid_amount) values ("
		//        + "'" + userid + "','" + gate + "','" + start_shift + "','" + end_shift + "','" + casual_amount + "','" + casual_qty + "',"
		//       + "'" + lt_amount + "','" + lt_qty + "','" + manual_amount + "','" + manual_qty + "','" + shift_id + "','" + prepaid_qty + "','" + prepaid_amount + "')
							 DB::table("settlement")
							 ->insert([
								"userid"=>$userid,
								"gate"=>$gate,
								"start_shift"=>$start_shift,
								"end_shift"=>$end_shift,
								"casual_amount"=>$casual_amount,
								"casual_qty"=>$casual_qty,
								"lt_amount"=>$lt_amount,
								"lt_qty"=>$lt_qty,
								"manual_amount"=>$manual_amount,
								"manual_qty"=>$manual_qty,
								"shift_id"=>$shift_id,
								"prepaid_qty"=>$prepaid_qty,
								"prepaid_amount"=>$prepaid_amount
							 ]);
						}
			
			
					
					return response()->json([
						'success' => true,
						'message' =>'Logout success',
						'data'    => null
						], 200);
			}
		}
	}
	
	
	public function master_vehicle(Request $request)
    {
		if($this->getBearerToken()  ==  false){
			//$this->response(array("code"=>2,"message"=>"Invalid credential")); 
			return response()->json([
				'success' => false,
				'message' =>'Invalid credential',
				'data'    => null
				], 200);
		}
		else{
			$validator = Validator::make($request->all(), [
				'site_id' => 'required',
			]);

			if ($validator->fails()) {

				return response()->json([
					'success' => false,
					'message' => 'Invalid post data!',
					'data'   => $validator->errors()
				],200);

			} else {

				$data = DB::table("casualcharges")
				->where("site_id",$request->site_id)
				->select("id as vehicle_code","vehicle_name","site_id")
				->get();
				
				if($data == null){
					return response()->json([
						'success' => false,
						'message' =>'Data not found',
						'data' => ''
						], 201);
				}
				else{
					return response()->json([
						'success' => true,
						'message' => null,
						'data' => $data
						], 200);
				}
			}
		}
    }
	
	public function master_lobby(Request $request)
    {
		if($this->getBearerToken()  ==  false){
			//$this->response(array("code"=>2,"message"=>"Invalid credential")); 
			return response()->json([
				'success' => false,
				'message' =>'Invalid credential',
				'data'    => null
				], 200);
		}
		else{
			$validator = Validator::make($request->all(), [
				'site_id' => 'required',
			]);

			if ($validator->fails()) {

				return response()->json([
					'success' => false,
					'message' => 'Invalid post data!',
					'data'   => $validator->errors()
				],200);

			} else {

				$data = DB::table("master_lobby")
				->where("site_id",$request->site_id)
				->get();
				
				if($data == null){
					return response()->json([
						'success' => false,
						'message' =>'Data not found',
						'data' => ''
						], 201);
				}
				else{
					return response()->json([
						'success' => true,
						'message' => null,
						'data' => $data
						], 200);
				}
			}
		}
    }
	
	public function cek_device(Request $request)
    {
		if($this->getBearerToken()  ==  false){
			//$this->response(array("code"=>2,"message"=>"Invalid credential")); 
			return response()->json([
				'success' => false,
				'message' =>'Invalid credential',
				'data'    => null
				], 200);
		}
		else{
			$validator = Validator::make($request->all(), [
				'site_id' => 'required',
				'device_id' => 'required',
			]);

			if ($validator->fails()) {

				return response()->json([
					'success' => false,
					'message' => 'Invalid post data!',
					'data'   => $validator->errors()
				],200);

			} else {

				$data = DB::table("master_device")
				->leftJoin("master_site","master_site.siteid","=","master_device.site_id")
				->where("site_id",$request->site_id)
				->where("device_id",$request->device_id)
				->select("master_site.siteid as site_id","master_site.sitename as site_name","master_device.device_id")
				->get()->first();
				if($data == null){
					return response()->json([
						'success' => false,
						'message' =>'Device not found',
						'data' => ''
						], 201);
				}
				else{
					return response()->json([
						'success' => true,
						'message' => null,
						'data' => $data
						], 200);
				}
			}
		}
    }
	
	
	function requestParkingRate(Request $request){
		if($this->getBearerToken()  ==  false){
			return response()->json([
				'success' => false,
				'message' =>'Invalid credential',
				'data'    => null
				], 200);
		}
		else
		{
			$validator = Validator::make($request->all(), [
				'ticket_no'   => 'required',
				//'vehicle_code' => 'required',
				'site_id' => 'required',
			]);

			if ($validator->fails()) {

				return response()->json([
					'success' => false,
					'message' => 'Invalid post data!',
					'data'   => $validator->errors()
				],200);

			} else {
				if ($request->ticket_no == '123') {

					return response()->json([
						'success' => false,
						'message' => 'Invalid ticket number!',
						'data'   => $validator->errors()
					],200);

				}
				
			
				$now = date('Y-m-d H:i:s');
				
				
				$data = DB::table("parking_in")
				->where("ti_qrcode",$request->ticket_no)
				->where("site_id",$request->site_id)
				->selectRaw("ti_key, ti_policeno, ti_vehicle, DATE_FORMAT(ti_datetime,'%d %b %Y %H:%i:%s') as parking_datetimein, 
                            DATE_FORMAT('$now','%d %b %Y %H:%i:%s') as waktu_keluar, CEIL(TIMESTAMPDIFF(SECOND, ti_datetime, 
							'$now')/60) as durasi, DAYOFWEEK(ti_datetime) as hari")
				->get()->first();
				//dd($data);
				if($data == null){
					return response()->json([
						'success' => false,
						'message' =>'Data not found',
						'parking_fee'    => null,
						'durasi1'    => "",
						'durasi2'    => "",
						'datetimein'    => "",
						'datetimeout'    => null,
						], 200);
				}
				else{
					return response()->json([
						'success' => true,
						'message' => null,
						'durasi1' => $data->durasi,
						'durasi2' => $this->konversi($data->durasi),
						'datetimein'    => $data->parking_datetimein,
						'datetimeout' => $data->waktu_keluar,
						'policeno' => $data->ti_policeno,
						'parking_fee'    => $this->hitung($data->ti_vehicle,$data->durasi,0,$request->site_id)
						], 200);
				}
			}
		}
	}
	
	function requestParkingRateManual(Request $request){
		
		if($this->getBearerToken()  ==  false){
			return response()->json([
				'success' => false,
				'message' =>'Invalid credential',
				'data'    => null
				], 200);
		}
		else
		{
			$validator = Validator::make($request->all(), [
				'datetimein'   => 'required', //format dd-mm-yyyy HH:mm
				'vehicle_code' => 'required',
				'site_id' => 'required',
				'isLT' => 'required',
			]);

			if ($validator->fails()) {

				return response()->json([
					'success' => false,
					'message' => 'Invalid post data!',
					'data'   => $validator->errors()
				],200);

			} else {
				if($request->site_id == "LOP"){
					$now = date('Y-m-d H:i:s', strtotime('now +1 hour'));
				}
				else{
					$now = date('Y-m-d H:i:s');
				}
				$data = DB::table("parking_in")
				->selectRaw("DATE_FORMAT(STR_TO_DATE('" .$request->datetimein. ":00','%d-%m-%Y %H:%i:%s'),'%Y-%m-%d %H:%i:%s') AS parking_datetimein, 
				'$now' AS waktu_keluar, ceil(TIMESTAMPDIFF(SECOND, STR_TO_DATE('" .$request->datetimein. ":00','%d-%m-%Y %H:%i:%s'), 
				'$now')/60) AS durasi, DAYOFWEEK(STR_TO_DATE('" .$request->datetimein. ":00','%d-%m-%Y %H:%i:%s')) as hari")->first();
				//dd($data);
				return response()->json([
						'success' => true,
						'message' => null,
						'durasi1' => $data->durasi,
						'durasi2' => $this->konversi($data->durasi),
						'datetimein' => $request->datetimein,
						'datetimeout' => $data->waktu_keluar,
						'lt' =>$request->isLT,
						'parking_fee'    => $this->hitung($request->vehicle_code,$data->durasi,$request->isLT, $request->site_id)
						], 200);
				
			}
		}
	}
	
	
	
	private function cekHari($site)
    {
		
		$nama_hari = date('l', strtotime(date('Y-m-d')));
		$now = date('Y-m-d');
		
				
				
            
		$cek = DB::table("harilibur")
		->select(DB::raw(" count(*) as cnt "))
		->whereRaw("tanggal = DATE_FORMAT(NOW(),'%Y-%m-%d')")
		->first();
			
		$ceklibur = $cek->cnt;
			

        if($ceklibur > 0)
        {
            $hasil = "Y";
        }
        else
        {
             $hasil = "N";
        }
        return $hasil;
    }
		
	private function hitung($kendaraan, $durasi, $isLT, $site)
    {
		//dd($this->cekHari($site));
		$jam = $durasi;
        if ($this->cekHari($site) == "Y")
        {
            $rstarif = DB::table("casualcharges")     
			->where("hari","H")
			->where("site_id",$site)
			->where("vehicle_name",$kendaraan)
			->whereRaw(" startdate <= NOW()")
			->first();
            
			if($rstarif != null){
				
			
                $charge_type = $rstarif->charge_type;
                $group1_unit = $rstarif->group1_unit;
                $group1_charge = $rstarif->group1_charge;
                $group2_unit = $rstarif->group2_unit;
                $group2_charge = $rstarif->group2_charge;
                $group3_unit = $rstarif->group3_unit;
                $group3_charge = $rstarif->group3_charge;
                $overnight_use = $rstarif->overnight_use;
                $overnight_charge = $rstarif->overnight_charge;
                $overnight_type = $rstarif->overnight_type;
                $overnight_unit = $rstarif->overnight_unit;
                $lt_charge = $rstarif->lt_charge;
                $maxcharge = $rstarif->maxcharge;
                $toleransi = $rstarif->tolerance;
            }

            else
            {
				 $rstarif = DB::table("casualcharges")     
				->where("hari","W")
				->where("site_id",$site)
				->where("vehicle_name",$kendaraan)
				->whereRaw(" startdate <= NOW()")
				->orderBY("startdate","DESC")
				->first();
				
				if($rstarif != null)
				{
					$charge_type = $rstarif->charge_type;
					$group1_unit = $rstarif->group1_unit;
					$group1_charge = $rstarif->group1_charge;
					$group2_unit = $rstarif->group2_unit;
					$group2_charge = $rstarif->group2_charge;
					$group3_unit = $rstarif->group3_unit;
					$group3_charge = $rstarif->group3_charge;
					$overnight_use = $rstarif->overnight_use;
					$overnight_charge = $rstarif->overnight_charge;
					$overnight_type = $rstarif->overnight_type;
					$overnight_unit = $rstarif->overnight_unit;
					$lt_charge = $rstarif->lt_charge;
					$maxcharge = $rstarif->maxcharge;
					$toleransi = $rstarif->tolerance;
				}
                       
                else{
					 $charge_type = "X";
					$group1_unit = 0;
					$group1_charge = 0;
					$group2_unit = 0;
					$group2_charge = 0;
					$group3_unit = 0;
					$group3_charge = 0;
					$overnight_use = "N";
					$overnight_charge = 0;
					$overnight_type = "P";
					$overnight_unit = 0;
					$lt_charge = 0;
					$maxcharge = 0;
					$toleransi = 0;
				}
                   
            }
		}
		else{
			//jika bukan hari libur
			
			$rstarif = DB::table("casualcharges")     
				->where("vehicle_name",$kendaraan)
				->where("site_id",$site)
				->whereRaw(" startdate <= NOW()")
				->orderBY("startdate","DESC")
				->first();
			//dd($rstarif);
				if($rstarif != null)
				{
					$charge_type = $rstarif->charge_type;
					$group1_unit = $rstarif->group1_unit;
					$group1_charge = $rstarif->group1_charge;
					$group2_unit = $rstarif->group2_unit;
					$group2_charge = $rstarif->group2_charge;
					$group3_unit = $rstarif->group3_unit;
					$group3_charge = $rstarif->group3_charge;
					$overnight_use = $rstarif->overnight_use;
					$overnight_charge = $rstarif->overnight_charge;
					$overnight_type = $rstarif->overnight_type;
					$overnight_unit = $rstarif->overnight_unit;
					$lt_charge = $rstarif->lt_charge;
					$maxcharge = $rstarif->maxcharge;
					$toleransi = $rstarif->tolerance;
				}
                       
                else{
					$charge_type = "X";
					$group1_unit = 0;
					$group1_charge = 0;
					$group2_unit = 0;
					$group2_charge = 0;
					$group3_unit = 0;
					$group3_charge = 0;
					$overnight_use = "N";
					$overnight_charge = 0;
					$overnight_type = "P";
					$overnight_unit = 0;
					$lt_charge = 0;
					$maxcharge = 0;
					$toleransi = 0;
				}
                  
		}
        
            //mulai hitung tarif
        if ($toleransi > 0)
        {
            $tol = 1;
        }
        else
        {
            $tol = 0;
        }
        if ($charge_type == "F")
        {
            if ($isLT == 1)
            {
                if ($tol == 1 && ($durasi <= $toleransi))
				{
                    $biayaparkir = $group1_charge;
                }
                else
                {
                   //$biayaparkir = $group1_charge + $lt_charge;
                    $biayaparkir = $group1_charge;
                }
            }
            else
            {
                if ($tol == 1 && ($durasi <= $toleransi))
                {
                    $biayaparkir = 0;
                }
                else
                {
                    $biayaparkir = $group1_charge;
                }
            }
        }
        else if ($charge_type == "X")
        {
            $biayaparkir = 123456789;
        }
        else
        {
            $biayaparkir = 0;
            if ($tol == 1 && ($durasi <= $toleransi))
            {
                if ($toleransi_maks == 0)
                {
                    $biayaparkir = 0;
                }

            }
            else
            {
                   //looping maksimal perhari

                while ($durasi > 0) //28880
                {


                    $tarif1 = $group1_charge;//5000
					//tarif jam pertama = 5000
                    $jam_kedua = ($durasi - $group1_unit); //90 - 60 = 30
					//jam kedua = 90 menit - 60 menit = 30 menit (jam kedua)
                    if ($jam_kedua < 1)
                    {
                        $biayaparkir_maks = $tarif1; //1000
                        $durasi = 0;
                    }
                    else
                    {
                        $tarif2 = $group2_charge; //1000
						//tarif jam kedua = 1000
                        $jam_ketiga = (floor($jam_kedua / $group2_unit)); // 30 - 60
						//jam ketiga = jam kedua - jam pertama , 30 menit - 
                        $jam_ketiga2 = $jam_ketiga;
                        if ($durasi < 1440)
                        {

                            //$biayaparkir_maks = ($tarif1 + $tarif2 + ($jam_ketiga2 * $group2_charge));
                            $biayaparkir_maks = ($tarif1 +$tarif2 + ($jam_ketiga2 * $group2_charge));
                            if ($maxcharge > 0 && ($biayaparkir_maks > $maxcharge))
                            {
                                $biayaparkir_maks = $maxcharge;
                            }
                            $durasi = 0;
							//$biayaparkir =  $biayaparkir + $biayaparkir_maks;
                        }
                        else
                        {
							
                            //$biayaparkir_maks = ($tarif1 + $tarif2 + ($jam_ketiga2 * $group2_charge));
                            $biayaparkir_maks = ($tarif2 + ($jam_ketiga2 * $group2_charge));
							//dd($biayaparkir_maks);
							
                            //$toleransi_maks = 1;
                            if ($maxcharge > 0 && ($biayaparkir_maks > $maxcharge))
                            {
                                    //total_maks = maxcharge;
                                $biayaparkir_maks = $maxcharge;
								$durasi = $durasi - 1440;
								 
                            }
							else{
								$durasi = 0;
							}
							
                        }
						
                    }
                    $biayaparkir = $biayaparkir + $biayaparkir_maks;
                }
             }
        }
		
		if($site == "LOP"){
			$jam  = ceil($jam / 60);
			if($jam <= 5){
				return array("biayaparkir"=>$biayaparkir,"lt_charge"=>$lt_charge,"jam"=>$durasi);
			}
			elseif($jam  >= 5 and $jam < 12 ){
				if($kendaraan == "MOBIL"){
					return array("biayaparkir"=>17500,"lt_charge"=>$lt_charge);
				}
				elseif($kendaraan == "BOX"){
					return array("biayaparkir"=>28000,"lt_charge"=>$lt_charge);
				}
				else{
					return array("biayaparkir"=>$biayaparkir,"lt_charge"=>$lt_charge,"jam"=>$jam);
				}
			}
			else{
				if($kendaraan == "MOBIL"){
					return array("biayaparkir"=>35000,"lt_charge"=>$lt_charge);
				}
				elseif($kendaraan == "BOX"){
					return array("biayaparkir"=>56000,"lt_charge"=>$lt_charge);
				}
				else{
					return array("biayaparkir"=>$biayaparkir,"lt_charge"=>$lt_charge,"jam"=>$jam);
				}
			}
			
		}else{
			return array("biayaparkir"=>$biayaparkir,"lt_charge"=>$lt_charge,"jam"=>$jam);
		}
		
		//return array("biayaparkir"=>$biayaparkir,"lt_charge"=>$lt_charge);
        
    }	
	
	public function saveTransaction(Request $request) {
		if($this->getBearerToken()  ==  false){
			return response()->json([
				'success' => false,
				'message' =>'Invalid credential',
				'data'    => null
				], 200);
		}
		else
		{
			$validator = Validator::make($request->all(), [
				'ticket_no'   => 'required', 
				//'vehicle_code' => 'required',
				//'policeno' => 'required',
				'user_id' => 'required',
				'device_id' => 'required',
				'site_id' => 'required',
				'shift_id' => 'required',
				'lobby_id' => 'required',
				//'datetimein' => 'required',
				'datetimeout' => 'required',
				'duration' => 'required',
				'parking_fee' => 'required',
				'isLT' => 'required',
				'lt_charge' => 'required',
				'payment_type' => 'required',
				'cardno' => 'required'
			]);

			if ($validator->fails()) {

				return response()->json([
					'success' => false,
					'message' => 'Invalid post data!',
					'data'   => $validator->errors()
				],200);

			} else {
				//save
				if ($request->ticket_no == '123' || $request->ticket_no == 'Capture' || $request->ticket_no == '') {

					return response()->json([
						'success' => false,
						'message' => 'Invalid ticket number!',
						'data'   => $validator->errors()
					],200);

				}
				
				$img = DB::table("parking_in")
				->where("ti_qrcode",$request->ticket_no)
				->where("site_id",$request->site_id)
				->select("ti_img","lobby_id","ti_policeno","ti_datetime","ti_userin","ti_vehicle","car_type","car_color")
				->first();
				
				if($img == null){
					$img_list = "";
					$lobby_in = "";
					$ti_policeno = "NA";
				}
				else{
					$img_list = $img->ti_img;
					$lobby_in = $img->lobby_id;
					$ti_policeno = $img->ti_policeno;
				}
				DB::table('parking_out_mobile')->insert([
					'transid'   => mt_rand(1111111111,9999999999), 
					'qrcode'   => $request->ticket_no, 
					'policeno' => $ti_policeno, 
					'vehicle' => $img->ti_vehicle, 
					'userout' => $request->user_id, 
					'device_id' => $request->device_id, 
					'site_id' => $request->site_id, 
					'shift_id' => $request->shift_id, 
					'datetimein' => $img->ti_datetime,
					'datetimeout' => date_format(date_create($request->datetimeout),"Y-m-d H:i:s"), 
					'durasi' => $request->duration, 
					'parking_fee' => $request->parking_fee, 
					'lt_fee' => $request->lt_charge, 
					'img_in' => $img_list, 
					'islt' => $request->isLT, 
					'gatein' => $lobby_in, 
					'gateout' => $request->lobby_id, 
					'payment_type' => $request->payment_type, 
					'pr_cardno' => $request->cardno, 
					'pr_cardtype' => $request->card_type, 
					'pr_translog' => $request->trans_log, 
					'pr_balance' => $request->card_balance, 
					'userin' => $img->ti_userin, 
					'car_type' => $img->car_type, 
					'car_color' => $img->car_color, 
				]);
				
				if($request->isLT == 0){
					DB::table("parking_in")
					->where("ti_qrcode",$request->ticket_no)
					->where("site_id",$request->site_id)
					->delete();
				}
				
				
				return response()->json([
					'success' => true,
					'message' => 'Success',
					'data'   => ""
				],201);
				
			}
		}
	}
	
	public function pos_in(Request $request) {
		if($this->getBearerToken()  ==  false){
			return response()->json([
				'success' => false,
				'message' =>'Invalid credential',
				'data'    => null
				], 200);
		}
		else
		{
			$validator = Validator::make($request->all(), [
				'site_id'   => 'required', 
				'device_id' => 'required',
				//'shift_id' => 'required',
				'lobby_id' => 'required',
				'police_no' => 'required',
				'vehicle' => 'required',
				'datetimein' => 'required'
			]);

			if ($validator->fails()) {

				return response()->json([
					'success' => false,
					'message' => 'Invalid post data!',
					'data'   => $validator->errors()
				],200);

			} else {
				//save
				
				$cek = DB::table("parking_in")
				->where("site_id" ,$request->site_id)
				->where("ti_policeno", $request->police_no)
				//->where("ti_datetime", $request->datetimein)
				->get()->count();
				//dd($cek);
				
				if($cek > 0){
					return response()->json([
					'success' => false,
					'message' => 'Kendaraan sudah di dalam area parkir!',
					'data'   => ""
					],200);
				}
				
				$qrcode = mt_rand(111111111111,999999999999)."PM".mt_rand(111,999);
				DB::table('parking_in')->insert([
					'ti_key'   => mt_rand(1111111111,9999999999), 
					'ti_qrcode'   => $qrcode, 
					'ti_policeno' => strtoupper($request->police_no), 
					'ti_vehicle' => $request->vehicle, 
					'ti_datetime' => $request->user_id, 
					'site_id' => $request->site_id, 
					'lobby_id' => $request->lobby_id, 
					//'shift_id' => $request->shift_id, 
					'ti_datetime' => $request->datetimein, 
					'ti_gatein' => $request->device_id, 
					'car_type' => $request->car_type, 
					'car_color' => $request->car_color, 
					'ti_cardno' => " ", 
					'ti_ticketno'   => $qrcode, 
					'ti_img'   => $request->parking_images, 
					'ti_userin' => "SYSTEM"
				]);
				//baru sampe sini utk save ke database parking_out_mobile
				return response()->json([
					'success' => true,
					'message' => 'Success',
					'qrcode'   => $qrcode
				],201);
				
			}
		}
	}
	private function konversi($menit)
    {
        $hasil = "";
        if ($menit < 59)
        {
            $hasil = ceil($menit) . " menit";
        }
        else if($menit > 1440)
        {
            $hari = $menit / 1440;
            $jam = ($menit % 1440) /60;
            $sisa = $jam % 60;
            $hasil = floor($hari) . " hr " . ceil($jam) . " jam " .ceil($sisa). " mnt";
           // $hasil = floor($menit / 60) . " jam  " .ceil($sisa). " menit";
        }
        else
        {
            $jam = $menit / 60;
            $sisa = $menit % 60;
            $hasil = floor($jam) . " jam " . ceil($sisa) . " menit";
        }
            return $hasil;
    }
	
	public function ovel(){
		/*
		$now = date('Y-m-d H:i:s');
		$data = DB::table("parking_in")
				->where("ti_qrcode","583447653575PM578")
				->where("site_id","SMB")
				->selectRaw("ti_key, ti_vehicle, DATE_FORMAT(ti_datetime,'%d-%m-%Y %H:%i') as parking_datetimein, 
                            '$now' as waktu_keluar, CEIL(TIMESTAMPDIFF(SECOND, ti_datetime, 
							NOW())/60) as durasi, DAYOFWEEK(ti_datetime) as hari, now()")
				->get();
		//dd($data);
		return response()->json([
					'success' => true,
					'message' => 'Success',
					'data'   => $data
				],201);
		*/
$sql = 
					"select users.userid,  users.shift_id,  users.fullname fullname, gateout, COUNT(*) AS qty, SUM(parking_fee) AS casual, 
            SUM(CASE WHEN lt_fee > 0 THEN 1 ELSE 0 END) AS qty_lt,
            SUM(CASE WHEN payment_type > 0 THEN 1 ELSE 0 END) AS prepaid_qty,
            SUM(CASE WHEN payment_type > 0 THEN parking_fee ELSE 0 END) AS prepaid_amount,
            SUM(CASE WHEN lt_fee > 0 THEN lt_fee ELSE 0 END) AS amount_lt,
            SUM(CASE WHEN userin = 'MANUAL' THEN 1 ELSE 0 END) AS qty_manual,
            SUM(CASE WHEN userin = 'MANUAL' THEN parking_fee ELSE 0 END) AS amount_manual, 
			DATE_FORMAT(users.startshift,'%Y-%m-%d %H:%i:%s') startshift, 
			DATE_FORMAT(users.endshift,'%Y-%m-%d %H:%i:%s') endshift
            FROM parking_out_mobile right join users on parking_out_mobile.userout = users.userid 
            where parking_out_mobile.shift_id = '123123'
            AND users.ustatus = 'E'  and users.userid='PP1' group by users.userid,
			users.fullname, parking_out_mobile.gateout, users.startshift, users.endshift, users.shift_id";
			
				$data = DB::select(DB::RAW($sql));
				
				//dd($data);
				foreach($data as $rs){
					$gate = $rs->gateout;
					$username = $rs->fullname;
					$userid = $rs->userid;
					$start_shift = $rs->startshift;
					$end_shift = $rs->endshift;
					$casual_amount = $rs->casual;
					$casual_qty =$rs->qty;
					$lt_amount = $rs->amount_lt;
					$lt_qty = $rs->qty_lt;  //$rs->qty_lt;
					$manual_amount = $rs->amount_manual;  //$rs->amount_manual;
					$manual_qty = $rs->qty_manual;  //$rs->qty_manual;
					$prepaid_qty = $rs->prepaid_qty;  //$rs->prepaid_qty;
					$prepaid_amount = $rs->prepaid_amount;
					$shift_id = $rs->shift_id;
//insert into settlement (userid, gate, start_shift, end_shift, casual_amount, casual_qty,"
//        + "lt_amount, lt_qty, manual_amount, manual_qty, shift_id, prepaid_qty,prepaid_amount) values ("
//        + "'" + userid + "','" + gate + "','" + start_shift + "','" + end_shift + "','" + casual_amount + "','" + casual_qty + "',"
//       + "'" + lt_amount + "','" + lt_qty + "','" + manual_amount + "','" + manual_qty + "','" + shift_id + "','" + prepaid_qty + "','" + prepaid_amount + "')
					 DB::table("settlement")
					 ->insert([
						"userid"=>$userid,
						"gate"=>$gate,
						"start_shift"=>$start_shift,
						"end_shift"=>$end_shift,
						"casual_amount"=>$casual_amount,
						"casual_qty"=>$casual_qty,
						"lt_amount"=>$lt_amount,
						"lt_qty"=>$lt_qty,
						"manual_amount"=>$manual_amount,
						"manual_qty"=>$manual_qty,
						"shift_id"=>$shift_id,
						"prepaid_qty"=>$prepaid_qty,
						"prepaid_amount"=>$prepaid_amount
					 ]);
				}
				return 'ok';
				
				//dd($rs);
				
	}
	
	function upload_img(Request $request){
		//dd($request->all());
		if($this->getBearerToken()  ==  false){
			return response()->json([
				'success' => false,
				'message' =>'Invalid credential',
				'data'    => null
				], 200);
		}
		else
		{
			$validator = Validator::make($request->all(), [
				'img_upload' => 'required'
			]);
			
			if ($validator->fails()) {

				return response()->json([
					'success' => false,
					'message' => 'Invalid post data!',
					'data'   => $validator->errors()
				],200);

			} else {
				
				$fname = mt_rand(111111,999999);
				
				//$base64DataString  = "data:image/jpeg;base64,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";
				$base64DataString  = $request->img_upload;
 
				$pattern = '/data:image\/(.+);base64,(.*)/';
				preg_match($pattern, $base64DataString, $matches);

				// image file extension
				$imageExtension = $matches[1];

				// base64-encoded image data
				$encodedImageData = $matches[2];

				// decode base64-encoded image data
				$decodedImageData = base64_decode($encodedImageData);

				// save image data as file
				file_put_contents(storage_path()."/parking_image/"."$fname.{$imageExtension}", $decodedImageData);
				
				DB::table('parking_image')->insert([
					'img_id'   => $fname,
					'img_name'   => $fname.".".$imageExtension,
				]);
				
				
				return response()->json([
					'success' => true,
					'message' => 'Success',
					'img_id'   => $fname
				],200);
				
			}
		}
	}
	
	function ticketnote(Request $request){
		if($this->getBearerToken()  ==  false){
			return response()->json([
				'success' => false,
				'message' =>'Invalid credential',
				'data'    => null
				], 200);
		}
		else
		{
			$validator = Validator::make($request->all(), [
				'site_id'   => 'required',
			]);

			if ($validator->fails()) {

				return response()->json([
					'success' => false,
					'message' => 'Invalid request parameter!',
					'data'   => $validator->errors()
				],200);

			} else {
				
				$data = DB::table("setting_ticket")
				->where("siteid",$request->site_id)
				->get()->first();
				
				if($data == null){
					return response()->json([
						'success' => false,
						'message' =>'',
						'data'    => null
						], 200);
				}
				else{
					return response()->json([
						'success' => true,
						'message' =>'OK',
						'data'    => $data
						], 200);
				}
			}
		}
	}
	
	function vehicletype(){
		if($this->getBearerToken()  ==  false){
			return response()->json([
				'success' => false,
				'message' =>'Invalid credential',
				'data'    => null
				], 200);
		}
		else
		{

				$data = DB::table("vehicle_brand")
				->leftJoin("vehicle_type","vehicle_brand.id","=","vehicle_type.brand_id")
				->selectRAW("CONCAT(vehicle_brand.brand_name,' > ', vehicle_type.type) AS vehicletype")
				->get();
				
				if($data == null){
					return response()->json([
						'success' => false,
						'message' =>'',
						'data'    => null
						], 200);
				}
				else{
					return response()->json([
						'success' => true,
						'message' =>'',
						'data'    => $data
						], 200);
				}
			
		}
	}
	
	function vehiclecolor(){
		if($this->getBearerToken()  ==  false){
			return response()->json([
				'success' => false,
				'message' =>'Invalid credential',
				'data'    => null
				], 200);
		}
		else
		{

				$data = DB::table("vehicle_color")
				->get();
				
				if($data == null){
					return response()->json([
						'success' => false,
						'message' =>'',
						'data'    => null
						], 200);
				}
				else{
					return response()->json([
						'success' => true,
						'message' =>'',
						'data'    => $data
						], 200);
				}
			
		}
	}
}